## Composite Component

In this tutorial, we will learn how to create a composite component. A composite component is a component that contains other components. It is a way to group components together and reuse them in other components.

For standard UIs, we usually use ```mui.FlexBox``` as a base class for composite components.

### Basic Usage

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class MyComponent(mui.FlexBox):
    def __init__(self):
        super().__init__([
            mui.Typography("Item 1").prop(border="1px solid red"),
        ])
        self.prop(flexDirection="row")

class MyComponent2(mui.FlexBox):
    def __init__(self):
        super().__init__([])
        self.prop(flexDirection="row")
        # use init_add_layout to add layout after init
        self.init_add_layout({
            "0": mui.Typography("Item 2").prop(border="1px solid blue"),
        })

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            MyComponent(),
            MyComponent2(),
        ]).prop(flex=1)

```

Another way to create a composite component is to use ```AnyLayout``` (any class with a layout function), like ```App``` in each example.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class MyComponent:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Typography("Item 1").prop(border="1px solid red"),
        ])


class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.flex_wrapper(MyComponent()),
        ]).prop(flex=1)

```